/*	Formatright  2009, OT

	Sound Block is free software;
	you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation.
	GNU General Public License as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Migraine; if not, write to the
	Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	Boston, MA 02111-1307, USA.
*/

/*  [Plugin Link]
	https://forums.alliedmods.net/showthread.php?t=100886
*/

/*  [Changelog]
- 6.2 - the plugin cannot be seen on game-monitor anymore (for surprize)
- 6.1 - Remade the function that gets the coords of the ground, more efficient, and faster, not laggy
- 6.0 - Well well, 100% CPU USAGE improvement, no more shot blockage
- 5.6 - Fixed the amxx crash bug when soundkey has been used
- 5.5 - Changed the way the command of creating soundkey works, added log to files, added more cvars for configuration, and miscelanous things
- 5.4 - Anti-Soundhack shot, pick-up and spawn
- 5.3 - Separated the channels from the shot mechanism (now we have the sound of the shot, the bullet particles and the weapon animation separated!)
- 5.2 - Fixed double jump/land sound, made the soundkey use less resources if the sounds that are used are default, removed PVS cvar (useless), new cvar wallblocker_footsteps
- 5.1 - PreHook fix, EmitAmbientSound function used, update key (more random and better when dealing with problems!)
- 5.0 - Added anti-soundhack based with key, made the ents follow the players much closer
- 4.8 - Less crash risk, new method of detecting transparent ents and making them transperent will not destroy ladded functionality anymore!!!
- 4.5 - texture check now isn't made that often (less crash risk!), added texture check autodisable cfg, added a new method to ignore entities that are transparent (100% efficient), reupdated the weapon headpoint
- 4.2 - added bitsum remember system, smooth check is made now by FRAME_CONSTANT (1/48), changed alive/dead recognision system (less resource use!)
- 4.1 - fixed plugin_init problem!
- 4.0 - all bugs fixed, added texture check , everything tweaked and tuned!
- 3.0 - removed Engine module (another method), improved smooth engine, removed , fixed flashing bug, target check now works both ways (if you are seen the player will be shown!)
- 2.5 - removed HamSandWich module (useless), improved smooth check, corpse remove bug fixed, optimized the code a little bit.
- 2.4 - bug fix release (weapon index out of bounds fix, reconnect bug fix (with CSDM), made the ent check not so sensitive (not so many blind-spots)
- 2.2 - bug fix release (index out of bounds & weapon confusion bug)
- 2.1 - removed a bugged feature (block_dead cvar), added smooth cvar
- 2.0 - more customizable, less cpu usage (50% TESTED!), weapons grenades check added, bug fixes
- 1.5 - removed some checks, optimized it a bit, added weapon head-point check
- 1.0 - initial release 
*/

/*  [Credits]
- joropito - for compiling engineX on linux
- hlstriker - for finding the way to detect semi-transparent textures!
- h010c - for tests and benchmarks, anti-soundhack tests and code samples
- joaquimandrade - for pointing out the plugin flaws, and for the Orpheu module
- Arkshine - for finding precise weapon head points, and for some sig files
- Mnx Community - for letting me test this plugin on linux!
- turshija - for some small suggestions.
- .Owyn. - bug reports
- ShlumPF* - for small improvements (initial v1.0)
- eD - for some tests
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include <engine>
#include <hamsandwich>

#define MAX_PLAYERS			32

// texture types
#define CHAR_TEX_CONCRETE	'C'			
#define CHAR_TEX_METAL		'M'		
#define CHAR_TEX_SNOW		'N'
#define CHAR_TEX_DIRT		'D'
#define CHAR_TEX_VENT		'V'
#define CHAR_TEX_GRATE		'G'
#define CHAR_TEX_TILE		'T'
#define CHAR_TEX_SLOSH		'S'
#define CHAR_TEX_WOOD		'W'
#define CHAR_TEX_COMPUTER	'P'
#define CHAR_TEX_GLASS		'Y'
#define CHAR_TEX_FLESH		'F'

// Step Types
#define STEP_CONCRETE		0		// default step sound
#define STEP_METAL			1		// metal floor
#define STEP_DIRT			2		// dirt, sand, rock
#define STEP_VENT			3		// ventillation duct
#define STEP_GRATE			4		// metal grating
#define STEP_TILE			5		// floor tiles
#define STEP_SLOSH			6		// shallow liquid puddle
#define STEP_WADE			7		// wading in liquid
#define STEP_LADDER			8		// climbing ladder
#define STEP_SNOW			9		// snow

#define FOOTSTEP_DIST		14.0
#define SND_ZVELOCITY		0.0
#define SND_MOVEVELOCITY	136.0
#define OFFSET_MINTRACE		70.0
#define SND_MULCONST		0.1

// For file copying
#define BUFFERSIZE    		256 

enum FWrite 
{ 
	FW_NONE = 0,
    FW_DELETESOURCE = (1<<0), 
    FW_CANOVERRIDE = (1<<1) 
} 

new gBS_Alive

#define add_alive_property(%1)						gBS_Alive |= (1<<(%1 - 1))
#define del_alive_property(%1)						gBS_Alive &= ~(1<<(%1 - 1))
#define has_alive_property(%1)						(gBS_Alive & (1<<(%1 - 1)))

new gPCV_on_off
new gPCV_footsteps

new gF_sndkey[300]
new gCLI_oldwaterlevel[MAX_PLAYERS + 1]
new gCLI_iStepLeft[MAX_PLAYERS + 1]
new gCLI_oldflags[MAX_PLAYERS + 1]
new bool:gB_DefaultSounds = false

new gI_SoundSize
new gSZ_SoundMod[128][60]
new gPSND_Indexes[10]
new gPTR_SoundPTR[128]
new bool:gB_loaded = true

stock gSPR_beampoint

new const gSZ_SoundList[94][] =
{
	"items/gunpickup2.wav",
	"player/pl_die1.wav",
	"player/pl_fallpain1.wav",
	"player/pl_fallpain2.wav",
	"player/pl_fallpain3.wav",
	"player/pl_pain2.wav",
	"player/pl_pain4.wav",
	"player/pl_pain5.wav",
	"player/pl_pain6.wav",
	"player/pl_pain7.wav",
	"player/pl_shell1.wav",
	"player/pl_shot1.wav",
	"player/sprayer.wav",
	"player/bhit_flesh-1.wav",
	"player/bhit_flesh-2.wav",
	"player/bhit_flesh-3.wav",
	"player/bhit_helmet-1.wav",
	"player/bhit_kevlar-1.wav",
	"player/headshot1.wav",
	"player/headshot2.wav",
	"player/headshot3.wav",
	"player/pl_dirt1.wav",
	"player/pl_dirt2.wav",
	"player/pl_dirt3.wav",
	"player/pl_dirt4.wav",
	"player/pl_duct1.wav",
	"player/pl_duct2.wav",
	"player/pl_duct3.wav",
	"player/pl_duct4.wav",
	"player/pl_jump1.wav",
	"player/pl_jump2.wav",
	"player/pl_ladder1.wav",
	"player/pl_ladder2.wav",
	"player/pl_ladder3.wav",
	"player/pl_ladder4.wav",
	"player/pl_grate1.wav",
	"player/pl_grate2.wav",
	"player/pl_grate3.wav",
	"player/pl_grate4.wav",
	"player/pl_metal1.wav",
	"player/pl_metal2.wav",
	"player/pl_metal3.wav",
	"player/pl_metal4.wav",
	"player/pl_slosh1.wav",
	"player/pl_slosh2.wav",
	"player/pl_slosh3.wav",
	"player/pl_slosh4.wav",
	"player/pl_snow1.wav",
	"player/pl_snow2.wav",
	"player/pl_snow3.wav",
	"player/pl_snow4.wav",
	"player/pl_snow5.wav",
	"player/pl_snow6.wav",
	"player/pl_step1.wav",
	"player/pl_step2.wav",
	"player/pl_step3.wav",
	"player/pl_step4.wav",
	"player/pl_swim1.wav",
	"player/pl_swim2.wav",
	"player/pl_swim3.wav",
	"player/pl_swim4.wav",
	"player/pl_tile1.wav",
	"player/pl_tile2.wav",
	"player/pl_tile3.wav",
	"player/pl_tile4.wav",
	"player/pl_tile5.wav",
	"player/pl_wade1.wav",
	"player/pl_wade2.wav",
	"player/pl_wade3.wav",
	"player/pl_wade4.wav",
	"weapons/boltdown.wav",
	"weapons/boltpull1.wav",
	"weapons/boltup.wav",
	"weapons/clipin1.wav",
	"weapons/clipout1.wav",
	"weapons/de_clipin.wav",
	"weapons/de_clipout.wav",
	"weapons/de_deploy.wav",
	"weapons/headshot2.wav",
	"weapons/pinpull.wav",
	"weapons/slideback1.wav",
	"weapons/sliderelease1.wav",
	"weapons/dryfire_pistol.wav",
	"weapons/dryfire_rifle.wav",
	"weapons/knife_deploy1.wav",
	"weapons/knife_hit1.wav",
	"weapons/knife_hit2.wav",
	"weapons/knife_hit3.wav",
	"weapons/knife_hit4.wav",
	"weapons/knife_hitwall1.wav",
	"weapons/knife_slash1.wav",
	"weapons/knife_slash2.wav",
	"weapons/knife_stab.wav",
	"weapons/zoom.wav"
}

public plugin_precache()
{
	// gSPR_beampoint = precache_model("sprites/laserbeam.spr")
	
	get_datadir(gF_sndkey, charsmax(gF_sndkey))
	format(gF_sndkey, charsmax(gF_sndkey),"%s/%s", gF_sndkey, "wb_sndkey.cfg")
	
	new bool:versionver = false
	
	// Use the normal sounds if we do not have a key!
	if (!file_exists(gF_sndkey))
	{
		server_print("[SND Block] Soundhack key not existent! Using default sounds!")
		
		for (new i=0;i<sizeof gSZ_SoundList;i++)
		{
			copy(gSZ_SoundMod[i], 59, gSZ_SoundList[i])
		}
		
		gI_SoundSize = sizeof gSZ_SoundList
		
		versionver = true
		gB_loaded = false
		gB_DefaultSounds = true
	}
	else
	{
		new pf = fopen(gF_sndkey, "r"), line[60]
		
		server_print("[SND Block] Soundhack key reading!")
		
		// Read key.
		while (!feof(pf))
		{
			fgets(pf, line, charsmax(line))
			
			if (line[0] == ';' || line[0] == '/')
				continue
			
			if (line[0] == 'v')
			{
				versionver = true
				if ( (line[1] == '5' && line[2] == '.' && (line[3] == '5' || line[3] == '6')) || line[1] == '6' )
				{
					server_print("[SND Block] Soundhack key version correspondence, eveything ok!")
				}
				else
				{
					server_print("[SND Block] Soundhack key version load failure (Version does not correspond). Using default sounds!")
					log_error(AMX_ERR_NONE, "[SND Block] Soundhack key version load failure (Version does not correspond). Using default sounds!")
					
					gB_DefaultSounds = true
					
					for (new i=0;i<sizeof gSZ_SoundList;i++)
					{
						copy(gSZ_SoundMod[i], 59, gSZ_SoundList[i])
					}
					
					gB_loaded = false
					
					gI_SoundSize = sizeof gSZ_SoundList
					
					break
				}
				
				continue
			}
			
			copy(gSZ_SoundMod[gI_SoundSize], 59, line)
			
			// Get rid of the "newline" parts
			replace(gSZ_SoundMod[gI_SoundSize], 59, "^n", "^0")
			gI_SoundSize++;
		}
		
		fclose(pf)
	}
	
	if (gI_SoundSize != sizeof gSZ_SoundList)
	{
		gB_DefaultSounds = true
		
		server_print("[SND Block] Soundhack key version load failure (Number of sounds does not correspond). Using default sounds!")
		log_error(AMX_ERR_NONE, "[SND Block] Soundhack key version load failure (Number of sounds does not correspond). Using default sounds!")
		
		for (new i=0;i<sizeof gSZ_SoundList;i++)
		{
			copy(gSZ_SoundMod[i], 59, gSZ_SoundList[i])
		}
		
		gB_loaded = false
	}
	
	if (!versionver)
	{
		gB_DefaultSounds = true
		
		server_print("[SND Block] Soundhack key version load failure (Version read failure). Using default sounds!")
		log_error(AMX_ERR_NONE, "[SND Block] Soundhack key version load failure (Version read failure). Using default sounds!")
		
		for (new i=0;i<sizeof gSZ_SoundList;i++)
		{
			copy(gSZ_SoundMod[i], 59, gSZ_SoundList[i])
		}
		
		gB_loaded = false
	}
	
	if (gB_loaded)
	{
		new filepath[300], filepath2[300]
		
		copy(filepath, charsmax(filepath), gSZ_SoundMod[0])
		replace(filepath, charsmax(filepath), "/", " ")
		parse(filepath, filepath, charsmax(filepath), filepath2, charsmax(filepath2))
		
		format(filepath, charsmax(filepath), "sound/%s", filepath)
		
		if (!dir_exists(filepath))
		{
			mkdir(filepath)
		}
		
		new bool:bSizeOk = true
		new bool:bExists = true
		
		for (new i=0;i<gI_SoundSize; i++)
		{
			format(filepath, charsmax(filepath), "sound/%s", gSZ_SoundList[i])
			format(filepath2, charsmax(filepath), "sound/%s", gSZ_SoundMod[i])
			
			if (!file_exists(filepath2))
			{
				if (!fcopy(filepath, filepath2))
				{
					bExists = false
					break
				}
			}
			else
			{
				if (!fcompare(filepath, filepath2))
				{
					bSizeOk = false
					gB_loaded = false
					break
				}
			}
			
		}
		
		if (!bExists)
		{
			server_print("[SND Block] Soundhack key version load failure (Unknown read\write error). Using default sounds!")
			log_error(AMX_ERR_NONE, "[SND Block] Soundhack key version load failure (Unknown read\write error). Using default sounds!")
			
			for (new i=0;i<sizeof gSZ_SoundList;i++)
			{
				copy(gSZ_SoundMod[i], 59, gSZ_SoundList[i])
			}
			
			gB_loaded = false
		}
		
		if (!bSizeOk)
		{
			server_print("[SND Block] Soundhack key version load failure (File size not maching). Using default sounds!")
			log_error(AMX_ERR_NONE, "[SND Block] Soundhack key version load failure (File size not maching). Using default sounds!")
			
			for (new i=0;i<sizeof gSZ_SoundList;i++)
			{
				copy(gSZ_SoundMod[i], 59, gSZ_SoundList[i])
			}
			
			gB_loaded = false
		}
		
		for (new i=0;i<gI_SoundSize && bSizeOk; i++)
		{
			gPTR_SoundPTR[i] = precache_sound(gSZ_SoundMod[i])
		}
		
		if (bSizeOk)
			server_print("[SND Block] Soundhack key loaded!")
	}
}

public plugin_init()
{
	register_plugin("SND Block", "6.2", "OT")
	
	gPCV_on_off     	= register_cvar("snb_enable",       "1")
	gPCV_footsteps  	= register_cvar("snb_footsteps", 	"1")
	
	register_forward(FM_PlayerPreThink,		"fw_freqthink"	   	, 0)
	register_forward(FM_PlayerPreThink,		"fw_freqthink"	   	, 1)
	register_forward(FM_PlayerPostThink,	"fw_freqthink"	   	, 0)
	register_forward(FM_PlayerPostThink,	"fw_freqthink"	   	, 1)
	register_forward(FM_EmitSound,			"fw_emitsound"		, 1)
	
	RegisterHam(Ham_Spawn, "player", "fw_alive_handle", 1)
	RegisterHam(Ham_Killed, "player", "fw_alive_handle", 1)
	
	register_srvcmd("amx_sndkeycfg", "cmd_sndkeycfg", ADMIN_IMMUNITY, "<command> <target>")
	
	gPSND_Indexes[STEP_CONCRETE] = getStringPos("player/pl_step1.wav")
	gPSND_Indexes[STEP_METAL] = getStringPos("player/pl_metal1.wav")
	gPSND_Indexes[STEP_DIRT] = getStringPos("player/pl_dirt1.wav")
	gPSND_Indexes[STEP_VENT] = getStringPos("player/pl_duct1.wav")
	gPSND_Indexes[STEP_GRATE] = getStringPos("player/pl_grate1.wav")
	gPSND_Indexes[STEP_TILE] = getStringPos("player/pl_tile1.wav")
	gPSND_Indexes[STEP_SLOSH] = getStringPos("player/pl_slosh1.wav")
	gPSND_Indexes[STEP_WADE] = getStringPos("player/pl_wade1.wav")
	gPSND_Indexes[STEP_LADDER] = getStringPos("player/pl_ladder1.wav")
	gPSND_Indexes[STEP_SNOW] = getStringPos("player/pl_snow1.wav")
	
}

public cmd_sndkeycfg(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
	{
		server_print("Usage: amx_sndkeycfg help - this will show you how to use the command")
		return PLUGIN_HANDLED
	}
	
	new arg[300]
	read_argv(1, arg, charsmax(arg))
	
	if (equali(arg, "help"))
	{
		server_print("Usage examples:")
		server_print("amx_sndkeycfg help - this will show you how to use the command")
		server_print("amx_sndkeycfg delete - this will delete the present soundkey (only if it was loaded)")
		server_print("amx_sndkeycfg create - this will delete the present soundkey (only if it was loaded) and create a new one")
		server_print("amx_sndkeycfg import <target> - this will import a soundkey from a file (will not override the present soundkey)")
		server_print("amx_sndkeycfg overimport <target> - this will import a soundkey from a file and delete the present one (only if it was loaded)")
		
		return PLUGIN_HANDLED
	}
	
	new filepath[300]
	new string1[128][21]
	new foldername[25] = "wb"
	
	
	if (equali(arg, "create"))
	{
		if (!file_exists(gF_sndkey))
		{
			for (new i=2;i < charsmax(foldername); i++)
			{
				foldername[i] = randomchar(random(3))
			}
			
			for (new i=0;i< sizeof gSZ_SoundList;i++)
			{
				// Here we create a random name for the new sound file
				for (new j=0;j<20;j++)
				{
					string1[i][j] = randomchar(random(3))
				}
				
				// Recheck for duplicates
				for (new j=0;j<i;j++)
				{
					if (equal(string1[i], string1[j]))
					{
						for (new j=0;j<20;j++)
						{
							string1[i][j] = randomchar(random(3))
						}
					}
				}
				
				// Add all that we need
				format(gSZ_SoundMod[i], 59, "%s/%s.wav", foldername, string1[i])
			}
			
			format(filepath, charsmax(filepath), "sound/%s",foldername)
			
			new pf = fopen(gF_sndkey, "w")
			fprintf(pf, "; DO NOT DELETE THIS FILE! UNLESS YOU KNOW WHAT YOU ARE DOING!!!^n")
			fprintf(pf, "v6.2^n")
			
			for (new i=0;i< sizeof gSZ_SoundList;i++)
			{
				if (i != sizeof gSZ_SoundList - 1)
				{
					fprintf(pf, "%s^n", gSZ_SoundMod[i])
				}
				else
				{
					fprintf(pf, "%s", gSZ_SoundMod[i])
				}
			}
			
			fclose(pf)
			
			server_print("[SND Block] Soundhack key created!")
		}
		else
		{
			if (!gB_loaded)
			{
				server_print("[SND Block] Soundhack key not loaded will not delete due to security measures!")
				return PLUGIN_HANDLED
			}
			
			delete_file(gF_sndkey)
			
			for (new i=0;i< sizeof gSZ_SoundList;i++)
			{
				format(filepath, charsmax(filepath), "sound/%s", gSZ_SoundMod[i])
				delete_file(filepath)
			}
			
			new filepath[300], filepath2[300]
			
			copy(filepath, charsmax(filepath), gSZ_SoundMod[0])
			replace(filepath, charsmax(filepath), "/", " ")
			parse(filepath, filepath, charsmax(filepath), filepath2, charsmax(filepath2))
			
			format(filepath, charsmax(filepath), "sound/%s", filepath)
			
			rmdir(filepath)
			
			for (new i=2;i < charsmax(foldername); i++)
			{
				foldername[i] = randomchar(random(3))
			}
			
			for (new i=0;i< sizeof gSZ_SoundList;i++)
			{
				// Here we create a random name for the new sound file
				for (new j=0;j<20;j++)
				{
					string1[i][j] = randomchar(random(3))
				}
				
				// Recheck for duplicates
				for (new j=0;j<i;j++)
				{
					if (equal(string1[i], string1[j]))
					{
						for (new j=0;j<20;j++)
						{
							string1[i][j] = randomchar(random(3))
						}
					}
				}
				
				// Add all that we need
				format(gSZ_SoundMod[i], 59, "%s/%s.wav", foldername, string1[i])
			}
			
			format(filepath, charsmax(filepath), "sound/%s",foldername)
			
			new pf = fopen(gF_sndkey, "w")
			fprintf(pf, "; DO NOT DELETE THIS FILE! UNLESS YOU KNOW WHAT YOU ARE DOING!!!^n")
			fprintf(pf, "v6.2^n")
			
			for (new i=0;i< sizeof gSZ_SoundList;i++)
			{
				if (i != sizeof gSZ_SoundList - 1)
				{
					fprintf(pf, "%s^n", gSZ_SoundMod[i])
				}
				else
				{
					fprintf(pf, "%s", gSZ_SoundMod[i])
				}
			}
			
			fclose(pf)
			
			server_print("[SND Block] Soundhack key created!")
		}
	}
	
	
	if (equali(arg, "delete"))
	{
		if (!file_exists(gF_sndkey))
		{
			server_print("[SND Block] No existent key! Cannot delete!")
			return PLUGIN_HANDLED
		}
		
		if (!gB_loaded)
		{
			server_print("[SND Block] Soundhack key not loaded will not delete due to security measures!")
			return PLUGIN_HANDLED
		}
		
		delete_file(gF_sndkey)
		new filepath[300]
		
		for (new i=0;i< sizeof gSZ_SoundList;i++)
		{
			format(filepath, charsmax(filepath), "sound/%s", gSZ_SoundMod[i])
			delete_file(filepath)
		}
		
		new filepath2[300]
		
		copy(filepath, charsmax(filepath), gSZ_SoundMod[0])
		replace(filepath, charsmax(filepath), "/", " ")
		parse(filepath, filepath, charsmax(filepath), filepath2, charsmax(filepath2))
		
		format(filepath, charsmax(filepath), "sound/%s", filepath)
		
		rmdir(filepath)
		
		server_print("[SND Block] Key deleted!")
		// Restart the server so we can load the key!
		server_cmd("restart")
		
		return PLUGIN_HANDLED
	}
	
	
	if (equali(arg, "import"))
	{
		if (file_exists(gF_sndkey))
		{
			server_print("[SND Block] Cannot override! Use")
			return PLUGIN_HANDLED
		}
		else
		{
			read_argv(2, arg, charsmax(arg))
			
			if (!file_exists(arg))
			{
				server_print("[SND Block] Invaild path specified! %s", arg)
				return PLUGIN_HANDLED
			}
			
			fcopy(arg, gF_sndkey)
		}
	}
	
	if (equali(arg, "overimport"))
	{
		read_argv(2, arg, charsmax(arg))
		
		if (!file_exists(arg))
		{
			server_print("[SND Block] Invaild path specified! %s", arg)
			return PLUGIN_HANDLED
		}
		
		if (file_exists(gF_sndkey))
		{
			if (!gB_loaded)
			{
				server_print("[SND Block] Soundhack key not loaded will not delete due to security measures!")
				return PLUGIN_HANDLED
			}
			
			delete_file(gF_sndkey)
			new filepath[300]
			
			for (new i=0;i< sizeof gSZ_SoundList;i++)
			{
				format(filepath, charsmax(filepath), "sound/%s", gSZ_SoundMod[i])
				delete_file(filepath)
			}
			
			new filepath2[300]
			
			copy(filepath, charsmax(filepath), gSZ_SoundMod[0])
			replace(filepath, charsmax(filepath), "/", " ")
			parse(filepath, filepath, charsmax(filepath), filepath2, charsmax(filepath2))
			
			format(filepath, charsmax(filepath), "sound/%s", filepath)
			
			rmdir(filepath)
		}
		
		fcopy(arg, gF_sndkey)
	}
	
	// Restart the server so we can load the key!
	server_cmd("restart")
	
	return PLUGIN_HANDLED
}

public fw_emitsound(id, channel, sample[], Float:volume, Float:att, flags, pitch)
{
	if (!get_pcvar_num(gPCV_on_off))
		return FMRES_IGNORED
	
	if(!is_user_alive(id))
		return FMRES_IGNORED
	
	if (!gB_DefaultSounds)
	{
		for(new i=0; i<sizeof gSZ_SoundList; i++)
		{
			if(equal(sample, gSZ_SoundList[i]))
			{
				static Float:origin[3]
				pev(id, pev_origin, origin)
				engfunc(EngFunc_EmitAmbientSound, 0, origin, gSZ_SoundMod[i], volume, att, flags, pitch);
				
				return FMRES_SUPERCEDE
			}
		}
	}
	else
	{
		static Float:origin[3]
		pev(id, pev_origin, origin)
		engfunc(EngFunc_EmitAmbientSound, 0, origin, sample, volume, att, flags, pitch)
		
		return FMRES_SUPERCEDE
	}
	
	return FMRES_IGNORED
}

public fw_freqthink(id)
{
	if (!get_pcvar_num(gPCV_footsteps) || !get_pcvar_num(gPCV_on_off))
		return FMRES_IGNORED
	
	if (!has_alive_property(id))
		return FMRES_IGNORED
	
	new waterLevel = entity_get_int(id, EV_INT_waterlevel)
	new iStepLeft = entity_get_int(id, EV_INT_iStepLeft)
	new flags = entity_get_int(id, EV_INT_flags)
	
	if (waterLevel > 1)
	{
		gCLI_oldwaterlevel[id] = waterLevel
		gCLI_iStepLeft[id] = iStepLeft
		gCLI_oldflags[id] = flags
		return FMRES_IGNORED
	}
	
	if (waterLevel == 1 && !!gCLI_iStepLeft[id] == !iStepLeft && get_velocity(id, true) > SND_MOVEVELOCITY)
	{
		PM_PlayStepSound(id, STEP_SLOSH, 0.60)
		gCLI_oldwaterlevel[id] = waterLevel
		gCLI_iStepLeft[id] = iStepLeft
		gCLI_oldflags[id] = flags
		return FMRES_IGNORED
	}
	
	if (entity_get_int(id, EV_INT_movetype) == MOVETYPE_FLY && !!gCLI_iStepLeft[id] == !iStepLeft && get_velocity(id, false) > SND_MOVEVELOCITY)
	{
		PM_PlayStepSound(id, STEP_LADDER, 0.8)
		gCLI_oldwaterlevel[id] = waterLevel
		gCLI_iStepLeft[id] = iStepLeft
		gCLI_oldflags[id] = flags
		return FMRES_IGNORED
	}
	
	if ((!!gCLI_iStepLeft[id] == !iStepLeft && (flags & FL_ONGROUND) && get_velocity(id, true) > SND_MOVEVELOCITY) || (!(flags & FL_ONGROUND) && (gCLI_oldflags[id] & FL_ONGROUND) && get_zveleocity(id) > SND_ZVELOCITY))
	{
		new Float:start[3], Float:end[3], ent
		
		gCLI_iStepLeft[id] = iStepLeft
		
		ent = getFootStepCoords(id, start, end)
		
		new texture[64]
		
		if (!trace_texture(ent, start, end, texture, charsmax(texture)))
		{
			PM_PlayStepSound(id, STEP_CONCRETE, 0.75)
			gCLI_oldwaterlevel[id] = waterLevel
			gCLI_oldflags[id] = flags
			
			return FMRES_IGNORED
		}
		
		PM_PlayStepSound(id, PM_MapTextureTypeStepType(dllfunc(DLLFunc_PM_FindTextureType, texture)), 0.75)
		
		gCLI_oldwaterlevel[id] = waterLevel
		gCLI_oldflags[id] = flags
		
		return FMRES_IGNORED 
	}
	else
	{
		gCLI_iStepLeft[id] = iStepLeft
		gCLI_oldwaterlevel[id] = waterLevel
		gCLI_oldflags[id] = flags
	}
	
	return FMRES_IGNORED 
}

public client_connect(id)
{
	del_alive_property(id)
}

public client_disconnect(id)
{
	del_alive_property(id)
}

public fw_alive_handle(id)
{
	if (!is_user_alive(id))
	{
		del_alive_property(id)
	}
	else
	{
		gCLI_oldwaterlevel[id] = entity_get_int(id, EV_INT_waterlevel)
		add_alive_property(id)
	}
}

stock xs_vec_add(const Float:in1[], const Float:in2[], Float:out[])
{
	out[0] = in1[0] + in2[0];
	out[1] = in1[1] + in2[1];
	out[2] = in1[2] + in2[2];
}

stock xs_vec_sub(const Float:in1[], const Float:in2[], Float:out[])
{
	out[0] = in1[0] - in2[0];
	out[1] = in1[1] - in2[1];
	out[2] = in1[2] - in2[2];
}

stock xs_vec_mul_scalar(const Float:vec[], Float:scalar, Float:out[])
{
	out[0] = vec[0] * scalar;
	out[1] = vec[1] * scalar;
	out[2] = vec[2] * scalar;
}

stock Float:xs_vec_len(const Float:vec[3])
{
	return floatsqroot(vec[0]*vec[0] + vec[1]*vec[1] + vec[2]*vec[2]);
}

stock Float:xs_vec_dot(const Float:vec[], const Float:vec2[])
{
	return (vec[0]*vec2[0] + vec[1]*vec2[1] + vec[2]*vec2[2])
}

stock bool:xs_vec_equal(const Float:vec1[], const Float:vec2[])
{
	return (vec1[0] == vec2[0]) && (vec1[1] == vec2[1]) && (vec1[2] == vec2[2]);
}

stock getFootStepCoords(id, Float:fstart[3], Float:fend[3])
{
	new Float:start[5][3], Float:end[5][3], Float:diff[5][3], Float:angle[3], Float:fwd[3], Float:right[3], ent[5], grndent, bool:halftests = false
	
	entity_get_vector(id, EV_VEC_v_angle, angle)
	
	angle_vector(angle, ANGLEVECTOR_FORWARD, fwd)
	fwd[2] = 0.0
	angle_vector(angle, ANGLEVECTOR_RIGHT, right)
	
	if (xs_vec_len(fwd) != 0.0)
		xs_vec_mul_scalar(fwd, FOOTSTEP_DIST/xs_vec_len(fwd), fwd)
	else
		halftests = true
	
	xs_vec_mul_scalar(right, FOOTSTEP_DIST/xs_vec_len(right), right)
	
	// Get Normal start and end origins
	entity_get_vector(id, EV_VEC_origin, start[0])
	end[0] = start[0]
	end[0][2] -= OFFSET_MINTRACE
	
	if (halftests)
	{
		xs_vec_add(start[0], right, start[1])
		xs_vec_sub(start[0], right, start[2])
		
		grndent = entity_get_edict(id, EV_ENT_groundentity)
		
		for (new i=0;i<3;i++)
		{
			ent[i] = trace_line(-1, start[i], end[i], diff[i])
			
			if (ent[i] == grndent)
			{
				fstart = start[i]
				fend = end[i]
				return ent[i]
			}
			
			if (!grndent)
			{
				if (!xs_vec_equal(diff[i], end[i]))
				{
					fstart = start[i]
					fend = end[i]
					return 0
				}
			}
		}
		
		fstart = start[2]
		fend = end[2]
		
		return ent[2] <= 0 ? 0 : ent[2]
	}
	
	xs_vec_add(start[0], fwd, start[1])
	xs_vec_add(start[1], right, start[1])
	
	xs_vec_add(start[0], fwd, start[2])
	xs_vec_sub(start[2], right, start[2])
	
	xs_vec_sub(start[0], fwd, start[3])
	xs_vec_add(start[3], right, start[3])
	
	xs_vec_sub(start[0], fwd, start[4])
	xs_vec_sub(start[4], right, start[4])
	
	xs_vec_add(end[0], fwd, end[1])
	xs_vec_add(end[1], right, end[1])
	
	xs_vec_add(end[0], fwd, end[2])
	xs_vec_sub(end[2], right, end[2])
	
	xs_vec_sub(end[0], fwd, end[3])
	xs_vec_add(end[3], right, end[3])
	
	xs_vec_sub(end[0], fwd, end[4])
	xs_vec_sub(end[4], right, end[4])
	
	grndent = entity_get_edict(id, EV_ENT_groundentity)
	
	for (new i=0;i<5;i++)
	{
		ent[i] = trace_line(-1, start[i], end[i], diff[i])
		
		if (ent[i] == grndent)
		{
			fstart = start[i]
			fend = end[i]
			return ent[i]
		}
		
		if (!grndent)
		{
			if (!xs_vec_equal(diff[i], end[i]))
			{
				fstart = start[i]
				fend = end[i]
				return 0
			}
		}
	}
	
	fstart = start[4]
	fend = end[4]
	
	return ent[4] <= 0 ? 0 : ent[4]
}

stock fcompare(read_path[300], dest_path[300])
{
	// Prepare for read  
	new fp_read = fopen(read_path, "rb") 

	// No file to read, errors! 
	if (!fp_read) 
	{ 
		fclose(fp_read) 
		return -1 
	} 
	
	// Prepare for read  
	new fp_read2 = fopen(dest_path, "rb") 

	// No file to read, errors! 
	if (!fp_read2) 
	{ 
		fclose(fp_read2) 
		return -1
	} 
	
	// Set to the end!
	fseek(fp_read, 0, SEEK_END);
	fseek(fp_read2, 0, SEEK_END);
	// Tell the file sizez, if equal that means that the size is the same!
	if (ftell(fp_read) == ftell(fp_read2))
	{
		fclose(fp_read)
		fclose(fp_read2)	
		return 1
	}
	
	fclose(fp_read)
	fclose(fp_read2)
	
	return 0
}
  
stock fcopy(read_path[300], dest_path[300], FWrite:flags = FW_NONE) 
{ 
	// Prepare for read  
	new fp_read = fopen(read_path, "rb") 

	// No file to read, errors! 
	if (!fp_read) 
	{ 
		fclose(fp_read) 
		return 0 
	} 

    // If the native cannot override 
	if (file_exists(dest_path) && !(flags & FW_CANOVERRIDE)) 
    {
		return 0 
    } 

	// Prepare for write  
	new fp_write = fopen(dest_path, "wb") 

	// Used for copying 
	static buffer[BUFFERSIZE] 
	static readsize 
  
	// Find the size of the files
	fseek(fp_read, 0, SEEK_END);
	new fsize = ftell(fp_read);
	fseek(fp_read, 0, SEEK_SET);
  
	// Here we copy the info 
	for (new j = 0; j < fsize; j += BUFFERSIZE) 
	{ 
		readsize = fread_blocks(fp_read, buffer, BUFFERSIZE, BLOCK_CHAR); 
		fwrite_blocks(fp_write, buffer, readsize, BLOCK_CHAR); 
	} 
  
	// Close the files 
	fclose(fp_read) 
	fclose(fp_write) 
  
	// Can delete source? 
	if (flags & FW_DELETESOURCE) 
		delete_file(read_path) 
  
	// Success 
	return 1 
}

stock PM_PlayStepSound(id, step, Float:fvol)
{
	new irand = random(2) + (entity_get_int(id, EV_INT_iStepLeft) * 2)
	
	switch (step)
	{
		case STEP_METAL:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_METAL] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_DIRT:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_DIRT] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_VENT:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_VENT] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_GRATE:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_GRATE] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_TILE:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_TILE] + ((random(101) < 90) ? getRemixedValues(irand) : 4)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_SLOSH:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_SLOSH] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_WADE:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_WADE] + irand], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_LADDER:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_LADDER] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		case STEP_SNOW:
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_SNOW] + random(6)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
		default: 
		{
			EmitSound( id, gSZ_SoundMod[gPSND_Indexes[STEP_CONCRETE] + getRemixedValues(irand)], fvol, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	
	return 1
}

stock EmitSound(ent, sample[], Float:fvol, Float:attn, flags, pitch)
{
	new Float:origin[3], Float:absmin[3], Float:velocity[3]
	entity_get_vector(ent, EV_VEC_absmin, absmin)
	entity_get_vector(ent, EV_VEC_origin, origin)
	entity_get_vector(ent, EV_VEC_velocity, velocity)
	
	origin[2] = absmin[2]
	
	xs_vec_mul_scalar(velocity, SND_MULCONST, velocity)
	
	xs_vec_add(origin, velocity, origin)
	
	engfunc(EngFunc_EmitAmbientSound, 0, origin, sample, fvol, attn, flags, pitch)
}

stock Float:get_velocity(ent, bool:use2d)
{
	new Float:vel[3]
	entity_get_vector(ent, EV_VEC_velocity, vel)
	
	if (use2d)
		vel[2] = 0.0
	
	return xs_vec_len(vel)
}

stock Float:get_zveleocity(ent)
{
	new Float:vel[3]
	entity_get_vector(ent, EV_VEC_velocity, vel)
	
	return vel[2]
}

stock PM_MapTextureTypeStepType(TextureType)
{
	switch (TextureType)
	{
		case CHAR_TEX_METAL: return STEP_METAL
		case CHAR_TEX_DIRT: return STEP_DIRT
		case CHAR_TEX_VENT: return STEP_VENT
		case CHAR_TEX_GRATE: return STEP_GRATE
		case CHAR_TEX_TILE: return STEP_TILE
		case CHAR_TEX_SLOSH: return STEP_SLOSH
		case CHAR_TEX_SNOW: return STEP_SNOW
		default: return STEP_CONCRETE
	}
	
	return STEP_CONCRETE
}

stock getRemixedValues(value)
{
	switch (value)
	{
		case 1: return 2
		case 2: return 1
		case 3: return 3
		default: return 0
	}
	
	return 0
}

stock getStringPos(string[])
{
	for (new i=0;i<94;i++)
	{
		if (equali(gSZ_SoundList[i],string))
			return i
	}
	return 0
}

stock draw_line(const Float:start[3], const Float:end[3])
{
	engfunc(EngFunc_MessageBegin, MSG_ALL, SVC_TEMPENTITY, Float:{0.0,0.0,0.0}, 0)
	write_byte(TE_gSPR_beampointS)
	write_fcoord(start[0])
	write_fcoord(start[1])
	write_fcoord(start[2])
	write_fcoord(end[0])
	write_fcoord(end[1])
	write_fcoord(end[2])
	write_short(gSPR_beampoint)
	write_byte(0)
	write_byte(0)
	write_byte(25)
	write_byte(10)
	write_byte(0)
	write_byte(255)
	write_byte(255)
	write_byte(255)
	write_byte(127)
	write_byte(1)
	message_end()	
}

stock randomchar(i)
{
	// 1 for big letters
	// 2 for small ones
	// The rest numbers
	switch(i)
	{
		case 1:
		{
			return random_num('A', 'Z')
		}
		case 2:
		{
			return random_num('a', 'z')
		}
		default:
		{
			return random_num('0', '9')
		}
	}
	
	return 'a'
}