/* AMX Mod X script

  :: Bazooka ::

  Usage:

    Type amx_bazooka in the console to drop a bazooka (admin only)

    Type buy_weapon in chat to open a buy menu (everyone)

  Cvars:

    amx_bazooka_dropping :: can a player drop his bazooka?? (default: 1)

    amx_bazooka_ammo :: how much ammo has the bazooka?? (default: 3)

    amx_bazooka_cost :: how much does the bazooka cost to buy it?? (default: 8000)

    amx_bazooka_buyable :: is it possible to buy the bazooka?? (default: 1)

    amx_bazooka_damageradius :: which damageradius should the bazooka have?? (default: 1000)

    amx_bazooka_maxdamage :: when you are in the center of the detonation, how much HP do you loose?? (default: 150)

  Special thanks to:

    -=STN=- MaGe
    KaOs
    RadidEskimo
    Freecode
    EJL
    JTP10181
    PaintLancer
    Kaddar
    Vexd
    twistedeuphoria
    XxAvalanchexX
    pimp daddy
    Ronkkrop

*/

#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <fun>
#include <cstrike>
#include <amxmisc>
#include <entity_maths>

new explosion, smoke, white, rocketsmoke
new bool:CanShoot[32]
new Munni[32]
new mode[32]
new bool:allow_shooting
new user_controll[32]
new bool:hasBazooka[32]

public plugin_init() {
  register_plugin("Bazooka", "0.9", "More")
  register_clcmd("amx_bazooka", "drop_rpg", ADMIN_KICK)

  register_cvar("amx_bazooka_dropping", "1")
  register_cvar("amx_bazooka_ammo", "3")
  register_cvar("amx_bazooka_damageradius", "1000")
  register_cvar("amx_bazooka_maxdamage", "150")
  register_cvar("amx_bazooka_cost", "8000")
  register_cvar("amx_bazooka_arena", "0")
  register_cvar("amx_bazooka_buyable", "1")

  register_clcmd("say", "handle_say")
  register_clcmd("say_team", "handle_say")

  if (find_ent_by_class(-1, "func_bomb_target") == 0) {
    register_event("DeathMsg", "player_die", "a")
    register_event("CurWeapon", "check_model", "be")
    register_event("TextMsg", "bomb_msg", "b", "2=#C4_Plant_At_Bomb_Spot")
    register_logevent("round_end", 2, "1=Round_End")
    register_logevent("round_start", 2, "1=Round_Start")

    register_clcmd("drop", "handle_drop")

    register_forward(FM_PlayerPreThink, "forward_playerprethink")
    register_forward(FM_SetModel, "forward_setmodel")

    register_menu("Bazooka Menu", 1023, "do_bazookamenu")
  }
}

public plugin_precache() {
  precache_model("models/rpgrocket.mdl")

  precache_model("models/w_rpg.mdl")
  precache_model("models/v_rpg.mdl")
  precache_model("models/p_rpg.mdl")

  precache_sound("weapons/rocketfire1.wav")
  precache_sound("weapons/nuke_fly.wav")
  precache_sound("weapons/mortarhit.wav")
  precache_sound("weapons/dryfire_rifle.wav")

  explosion = precache_model("sprites/fexplo.spr")
  smoke  = precache_model("sprites/steam1.spr")
  white = precache_model("sprites/white.spr")
  rocketsmoke = precache_model("sprites/smoke.spr")
}

public bomb_msg() {
  client_print(0, print_center, "")
}

public round_end() {
  set_task(4.5, "round_prestart")
  set_task(5.0, "player_spawn")
  set_task(5.5, "bazooka_arena")
}

public round_prestart() {
  allow_shooting = false
}

public round_start() {
  allow_shooting = true
}

public bazooka_arena() {
  if (get_cvar_num("amx_bazooka_arena") == 1) {
    new players[32], count
    get_players(players, count)
    for (new i = 0; i < count; i++) {

      give_item(players[i], "weapon_c4")
      hasBazooka[players[i]] = true

      client_print(players[i], print_chat, "[Bazooka] You have been given a bazooka!")
      client_print(players[i], print_chat, "[Bazooka] Use alternate fire (+attack2) to change the shooting mode!")
    }
  }

  return PLUGIN_HANDLED
}

public fire_rocket(id) {
  CanShoot[id] = false

  new data[1]
  data[0] = id
  set_task(3.0, "rpg_reload", id+9477, data, 1)

  if ((Munni[id] <= 0) && (get_cvar_num("amx_bazooka_arena") != 1)) {

    emit_sound(id, CHAN_WEAPON, "weapons/dryfire_rifle.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

    return PLUGIN_HANDLED
  }

  new Float:StartOrigin[3], Float:Angle[3]

  new PlayerOrigin[3]
  get_user_origin(id, PlayerOrigin, 1)

  StartOrigin[0] = float(PlayerOrigin[0])
  StartOrigin[1] = float(PlayerOrigin[1])
  StartOrigin[2] = float(PlayerOrigin[2])

  entity_get_vector(id, EV_VEC_v_angle, Angle)
  Angle[0] = Angle[0] * -1.0
  new RocketEnt = create_entity("info_target")
  entity_set_string(RocketEnt, EV_SZ_classname, "rpgrocket")
  entity_set_model(RocketEnt, "models/rpgrocket.mdl")
  entity_set_origin(RocketEnt, StartOrigin)
  entity_set_vector(RocketEnt, EV_VEC_angles, Angle)

  new Float:MinBox[3] = {-1.0, -1.0, -1.0}
  new Float:MaxBox[3] = {1.0, 1.0, 1.0}
  entity_set_vector(RocketEnt, EV_VEC_mins, MinBox)
  entity_set_vector(RocketEnt, EV_VEC_maxs, MaxBox)

  entity_set_int(RocketEnt, EV_INT_solid, 2)
  entity_set_int(RocketEnt, EV_INT_movetype, 5)
  entity_set_edict(RocketEnt, EV_ENT_owner, id)

  new Float:Velocity[3]
  VelocityByAim(id, 1000, Velocity)
  entity_set_vector(RocketEnt, EV_VEC_velocity, Velocity)

  emit_sound(RocketEnt, CHAN_WEAPON, "weapons/rocketfire1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
  emit_sound(RocketEnt, CHAN_VOICE, "weapons/nuke_fly.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

  if (get_cvar_num("amx_bazooka_arena") != 1) {
    ammo_hud(id, 0)
    Munni[id]--
    ammo_hud(id, 1)
  }

  message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
  write_byte(22)
  write_short(RocketEnt)
  write_short(rocketsmoke)
  write_byte(30)
  write_byte(3)
  write_byte(255)
  write_byte(255)
  write_byte(255)
  write_byte(255)
  message_end()

  if (mode[id] == 2) {
    new info[1]
    info[0] = RocketEnt
    set_task(1.0, "find_and_follow", 0, info, 1)
  }
  else if (mode[id] == 3) {
    entity_set_int(RocketEnt, EV_INT_rendermode, 1)
    attach_view(id, RocketEnt)
    user_controll[id] = RocketEnt
  }

  return PLUGIN_HANDLED
}

public rpg_reload(data[]) {
  CanShoot[data[0]] = true
}

public find_and_follow(info[]) {
  new RocketEnt = info[0]
  new Float:shortestDist = 10000.0
  new nearestPlayer = 0

  if (is_valid_ent(RocketEnt)) {
    new players[32], count
    get_players(players, count)
    for (new i = 0; i < count; i++) {
      if (is_user_alive(players[i]) && (entity_get_edict(RocketEnt, EV_ENT_owner) != players[i]) && (get_user_team(players[i]) != get_user_team(entity_get_edict(RocketEnt, EV_ENT_owner)))) {
        new Float:PlayerOrigin[3], Float:RocketOrigin[3]
        entity_get_vector(players[i], EV_VEC_origin, PlayerOrigin)
        entity_get_vector(RocketEnt, EV_VEC_origin, RocketOrigin)

        new Float:distance = vector_distance(PlayerOrigin, RocketOrigin)

        if (distance <= shortestDist) {
          shortestDist = distance
          nearestPlayer = players[i]
        }
      }
    }
  }

  if (nearestPlayer > 0) {
    new data[2]
    data[0] = RocketEnt
    data[1] = nearestPlayer
    set_task(0.1, "follow_and_catch", RocketEnt, data, 2, "b")
  }
  else {
    pfn_touch(RocketEnt, 0)
  }
}

public follow_and_catch(data[]) {
  new RocketEnt = data[0]
  new target = data[1]

  if (is_user_alive(target) && is_valid_ent(RocketEnt)) {
    entity_set_follow(RocketEnt, target, 500.0)

    new Float:Velocity[3]
    new Float:NewAngle[3]
    entity_get_vector(RocketEnt, EV_VEC_velocity, Velocity)
    vector_to_angle(Velocity, NewAngle)
    entity_set_vector(RocketEnt, EV_VEC_angles, NewAngle)
  }
  else {
    remove_task(RocketEnt)

    new info[1]
    info[0] = RocketEnt
    set_task(0.1, "find_and_follow", 0, data, 1)
  }
}

public pfn_touch(ptr, ptd) {
  new ClassName[32]

  if ((ptr > 0) && is_valid_ent(ptr)) {
    entity_get_string(ptr, EV_SZ_classname, ClassName, 31)
  }

  if (equal(ClassName, "rpgrocket")) {

    remove_task(ptr)

    new Float:EndOrigin[3]
    entity_get_vector(ptr, EV_VEC_origin, EndOrigin)

    emit_sound(ptr, CHAN_WEAPON, "weapons/mortarhit.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
    emit_sound(ptr, CHAN_VOICE, "weapons/mortarhit.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

    message_begin(MSG_BROADCAST, SVC_TEMPENTITY)  // Feuerball
    write_byte(17)
    write_coord(floatround(EndOrigin[0]))
    write_coord(floatround(EndOrigin[1]))
    write_coord(floatround(EndOrigin[2]) + 128)
    write_short(explosion)
    write_byte(60)
    write_byte(255)
    message_end()

    message_begin(MSG_BROADCAST, SVC_TEMPENTITY)  // Rauchwolke
    write_byte(5)
    write_coord(floatround(EndOrigin[0]))
    write_coord(floatround(EndOrigin[1]))
    write_coord(floatround(EndOrigin[2]) + 256)
    write_short(smoke)
    write_byte(125)
    write_byte(5)
    message_end()

    new maxdamage = get_cvar_num("amx_bazooka_maxdamage")
    new damageradius = get_cvar_num("amx_bazooka_damageradius")

    new PlayerPos[3], distance, damage
    for (new i = 1; i < 32; i++) {
      if (is_user_alive(i) == 1) {
        get_user_origin(i, PlayerPos)

        new NonFloatEndOrigin[3]
        NonFloatEndOrigin[0] = floatround(EndOrigin[0])
        NonFloatEndOrigin[1] = floatround(EndOrigin[1])
        NonFloatEndOrigin[2] = floatround(EndOrigin[2])

        distance = get_distance(PlayerPos, NonFloatEndOrigin)
        if (distance <= damageradius) {  // Schadensradius
          message_begin(MSG_ONE, get_user_msgid("ScreenShake"), {0,0,0}, i)  // Schtteln
          write_short(1<<14)
          write_short(1<<14)
          write_short(1<<14)
          message_end()

          damage = maxdamage - floatround(floatmul(float(maxdamage), floatdiv(float(distance), float(damageradius))))
          new attacker = entity_get_edict(ptr, EV_ENT_owner)

          if (!get_user_godmode(i)) {

            if (get_user_team(attacker) != get_user_team(i)) {

              if (damage < get_user_health(i)) {
                set_user_health(i, get_user_health(i) - damage)
              }
              else {
                set_msg_block(get_user_msgid("DeathMsg"), BLOCK_SET)
                user_kill(i, 1)
                set_msg_block(get_user_msgid("DeathMsg"), BLOCK_NOT)

                message_begin(MSG_BROADCAST, get_user_msgid("DeathMsg"))  // Kill-Log oben rechts
                write_byte(attacker)  // Attacker
                write_byte(i)  // Victim
                write_byte(0)  // Headshot
                write_string("bazooka")
                message_end()

                set_user_frags(attacker, get_user_frags(attacker) + 1)
              }

            }
            else {
              if (attacker == i) {

                if (damage < get_user_health(i)) {
                  set_user_health(i, get_user_health(i) - damage)
                }
                else {
                  set_msg_block(get_user_msgid("DeathMsg"), BLOCK_SET)
                  user_kill(i, 1)
                  set_msg_block(get_user_msgid("DeathMsg"), BLOCK_NOT)

                  message_begin(MSG_BROADCAST, get_user_msgid("DeathMsg"))  // Kill-Log oben rechts
                  write_byte(attacker)  // Attacker
                  write_byte(i)  // Victim
                  write_byte(0)  // Headshot
                  write_string("bazooka")
                  message_end()

                  set_user_frags(attacker, get_user_frags(attacker) - 1)
                }

              }
              else {
                if (get_cvar_num("mp_friendlyfire")) {

                  if (damage < get_user_health(i)) {
                    set_user_health(i, get_user_health(i) - damage)

                    client_print(attacker, print_center, "You injured a teammate!")
                  }
                  else {
                    set_msg_block(get_user_msgid("DeathMsg"), BLOCK_SET)
                    user_kill(i, 1)
                    set_msg_block(get_user_msgid("DeathMsg"), BLOCK_NOT)

                    message_begin(MSG_BROADCAST, get_user_msgid("DeathMsg"))  // Kill-Log oben rechts
                    write_byte(attacker)  // Attacker
                    write_byte(i)  // Victim
                    write_byte(0)  // Headshot
                    write_string("bazooka")
                    message_end()

                    set_user_frags(attacker, get_user_frags(attacker) - 1)

                    client_print(attacker, print_center, "You killed a teammate!")
                  }
                }
              }
            }
          }
        }
      }
    }

    message_begin(MSG_BROADCAST, SVC_TEMPENTITY)  // Druckwelle
    write_byte(21)
    write_coord(floatround(EndOrigin[0]))
    write_coord(floatround(EndOrigin[1]))
    write_coord(floatround(EndOrigin[2]))
    write_coord(floatround(EndOrigin[0]))
    write_coord(floatround(EndOrigin[1]))
    write_coord(floatround(EndOrigin[2]) + 320)
    write_short(white)
    write_byte(0)
    write_byte(0)
    write_byte(16)
    write_byte(128)
    write_byte(0)
    write_byte(255)
    write_byte(255)
    write_byte(192)
    write_byte(128)
    write_byte(0)
    message_end()

    attach_view(entity_get_edict(ptr, EV_ENT_owner), entity_get_edict(ptr, EV_ENT_owner))
    user_controll[entity_get_edict(ptr, EV_ENT_owner)] = 0
    remove_entity(ptr)
  }

  if (equal(ClassName, "rpg") || equal(ClassName, "rpg_temp")) {
    new Picker[32]
    if ((ptd > 0) && is_valid_ent(ptd)) {
      entity_get_string(ptd, EV_SZ_classname, Picker, 31)
    }

    if (equal(Picker, "player")) {

      give_item(ptd, "weapon_c4")
      hasBazooka[ptd] = true
      Munni[ptd] = Munni[ptd] + entity_get_int(ptr, EV_INT_iuser1)

      client_print(ptd, print_chat, "[Bazooka] You have picked up a bazooka!")
      client_print(ptd, print_chat, "[Bazooka] Use alternate fire (+attack2) to change the shooting mode!")

      remove_entity(ptr)
    }
  }
}

public drop_rpg(id, level, cid) {
  if (!cmd_access(id, level, cid, 1)) {
    return PLUGIN_HANDLED
  }

  if (find_ent_by_class(-1, "func_bomb_target") != 0) {
    client_print(id, print_console, "You cannot drop the Bazooka on bomb-maps!!")
    return PLUGIN_HANDLED
  }

  new Float:PlayerOrigin[3], Float:End[3], Float:Return[3], Float:TraceDirection[3]
  entity_get_vector(id, EV_VEC_origin, PlayerOrigin)
  VelocityByAim(id, 64, TraceDirection)

  End[0] = TraceDirection[0] + PlayerOrigin[0]
  End[1] = TraceDirection[1] + PlayerOrigin[1]
  End[2] = TraceDirection[2] + PlayerOrigin[2]

  trace_line(id, PlayerOrigin, End, Return)
  Return[2] = PlayerOrigin[2]

  new RPG = create_entity("info_target")
  entity_set_string(RPG, EV_SZ_classname, "rpg")
  entity_set_model(RPG, "models/w_rpg.mdl")
  entity_set_origin(RPG, Return)

  new Float:MinBox[3] = {-16.0, -16.0, 0.0}
  new Float:MaxBox[3] = {16.0, 16.0, 16.0}
  entity_set_vector(RPG, EV_VEC_mins, MinBox)
  entity_set_vector(RPG, EV_VEC_maxs, MaxBox)

  entity_set_int(RPG, EV_INT_solid, 1)
  entity_set_int(RPG, EV_INT_movetype, 6)

  entity_set_int(RPG, EV_INT_iuser1, get_cvar_num("amx_bazooka_ammo"))

  return PLUGIN_HANDLED
}

public forward_playerprethink(id) {
  if (is_user_alive(id)) {
    new weaponid, clip, ammo
    weaponid = get_user_weapon(id, clip, ammo)
    if ((weaponid == CSW_C4) && hasBazooka[id]) {
      new attack = get_user_button(id) & IN_ATTACK
      new oldattack = get_user_oldbutton(id) & IN_ATTACK
      new attack2 = get_user_button(id) & IN_ATTACK2
      new oldattack2 = get_user_oldbutton(id) & IN_ATTACK2

      if (attack && !oldattack) {
        if (CanShoot[id] && allow_shooting && (user_controll[id] == 0)) {
          fire_rocket(id)
        }
      }
      else if (attack2 && !oldattack2) {
        switch(mode[id]) {
          case 1: {
            mode[id] = 2
            client_print(id, print_center, "Switched to heat-seeking mode")
          }
          case 2: {
            mode[id] = 3
            client_print(id, print_center, "Switched to user-guided mode")
          }
          case 3: {
            mode[id] = 1
            client_print(id, print_center, "Switched to normal mode")
          }
        }
      }
    }
    if (user_controll[id] > 0) {
      new RocketEnt = user_controll[id]
      if (is_valid_ent(RocketEnt)) {
        new Float:Velocity[3]
        VelocityByAim(id, 500, Velocity)
        entity_set_vector(RocketEnt, EV_VEC_velocity, Velocity)
        new Float:NewAngle[3]
        entity_get_vector(id, EV_VEC_v_angle, NewAngle)
        entity_set_vector(RocketEnt, EV_VEC_angles, NewAngle)
      }
      else {
        attach_view(id, id)
      }
    }
  }
  return FMRES_IGNORED
}

public forward_setmodel(entity, model[]) {
  if (!is_valid_ent(entity)) {
    return FMRES_IGNORED
  }
  if (equal(model, "models/w_backpack.mdl")) {
    client_print(0, print_center, "")
    new ClassName[32]
    entity_get_string(entity, EV_SZ_classname, ClassName, 31)

    if (equal(ClassName, "weaponbox")) {

      remove_entity(entity)

      return FMRES_SUPERCEDE
    }
  }
  return FMRES_IGNORED
}

public check_model(id) {
  new weaponid, clip, ammo
  weaponid = get_user_weapon(id, clip, ammo)
  if (weaponid == CSW_C4) {
    ammo_hud(id, 1)
    entity_set_string(id, EV_SZ_viewmodel, "models/v_rpg.mdl")
    entity_set_string(id, EV_SZ_weaponmodel, "models/p_rpg.mdl")
  }
  else {
    ammo_hud(id, 0)
  }
  return PLUGIN_HANDLED
}

public client_connect(id) {
  CanShoot[id] = true
  Munni[id] = 0
  mode[id] = 1
  hasBazooka[id] = false
}

ammo_hud(id, show) {
  new AmmoHud[33]
  if (get_cvar_num("amx_bazooka_arena") == 1) {
    format(AmmoHud, 32, "Ammunition: Unlimited")
  }
  else {
    format(AmmoHud, 32, "Ammunition: %i", Munni[id])
  }

  if (show) {
    message_begin(MSG_ONE, get_user_msgid("StatusText"), {0,0,0}, id)
    write_byte(0)
    write_string(AmmoHud)
    message_end()
  }
  else {
    message_begin(MSG_ONE, get_user_msgid("StatusText"), {0,0,0}, id)
    write_byte(0)
    write_string("")
    message_end()
  }
}

public player_die() {

  new victim
  victim = read_data(2)

  ammo_hud(victim, 0)
  Munni[victim] = 0
  hasBazooka[victim] = false
}

public player_spawn() {
  new players[32], count
  get_players(players, count)
  for (new i = 0; i < count; i++) {
    if (is_user_alive(players[i])) {
      new v_oldmodel[64], p_oldmodel[64]
      entity_get_string(players[i], EV_SZ_viewmodel, v_oldmodel, 63)
      entity_get_string(players[i], EV_SZ_weaponmodel, p_oldmodel, 63)
      if (equal(v_oldmodel, "models/v_rpg.mdl") || equal(p_oldmodel, "models/p_rpg.mdl")) {
        if (!hasBazooka[players[i]]) {
          new weaponid, clip, ammo
          weaponid = get_user_weapon(players[i], clip, ammo)

          new weaponname[64]
          get_weaponname(weaponid, weaponname, 63)

          new v_model[64], p_model[64]
          format(v_model, 63, "%s", weaponname)
          format(p_model, 63, "%s", weaponname)

          replace(v_model, 63, "weapon_", "v_")
          format(v_model, 63, "models/%s.mdl", v_model)
          entity_set_string(players[i], EV_SZ_viewmodel, v_model)

          replace(p_model, 63, "weapon_", "p_")
          format(p_model, 63, "models/%s.mdl", p_model)
          entity_set_string(players[i], EV_SZ_weaponmodel, p_model)
        }
      }
    }
  }

  new TempRocket = find_ent_by_class(-1, "rpgrocket")
  while (TempRocket > 0) {
    remove_entity(TempRocket)
    TempRocket = find_ent_by_class(TempRocket, "rpgrocket")
  }

  new TempRPG = find_ent_by_class(-1, "rpg_temp")
  while (TempRPG > 0) {
    remove_entity(TempRPG)
    TempRPG = find_ent_by_class(TempRPG, "rpg_temp")
  }

  return PLUGIN_HANDLED
}

public handle_drop(id) {
  if (read_argc() > 1) {
    new weapon[17]
    read_argv(1, weapon, 16)
    if (equal(weapon, "weapon_c4")) {
      new weapons[32], count
      get_user_weapons(id, weapons, count)
      for (new i = 0; i < count; i++) {
        if (weapons[i] == 6) {
          if (get_cvar_num("amx_bazooka_dropping") == 1) {
            drop_rpg_temp(id)
          }
          else {
            client_print(id, print_center, "This weapon cannot be dropped")
            return PLUGIN_HANDLED
          }
        }
      }
    }
  }
  else {
    new weaponid, clip, ammo
    weaponid = get_user_weapon(id, clip, ammo)
    if (weaponid == CSW_C4) {
      if (get_cvar_num("amx_bazooka_dropping") == 1) {
        drop_rpg_temp(id)
      }
      else {
        client_print(id, print_center, "This weapon cannot be dropped")
        return PLUGIN_HANDLED
      }
    }
  }

  return PLUGIN_CONTINUE
}

public drop_rpg_temp(id) {

  new Float:PlayerOrigin[3], Float:End[3], Float:Return[3], Float:TraceDirection[3], Float:Angles[3]
  entity_get_vector(id, EV_VEC_origin, PlayerOrigin)
  entity_get_vector(id, EV_VEC_angles, Angles)
  VelocityByAim(id, 96, TraceDirection)

  End[0] = TraceDirection[0] + PlayerOrigin[0]
  End[1] = TraceDirection[1] + PlayerOrigin[1]
  End[2] = TraceDirection[2] + PlayerOrigin[2]

  trace_line(id, PlayerOrigin, End, Return)
  Return[2] = PlayerOrigin[2]

  new RPG = create_entity("info_target")
  entity_set_string(RPG, EV_SZ_classname, "rpg_temp")
  entity_set_model(RPG, "models/w_rpg.mdl")
  entity_set_origin(RPG, Return)

  Angles[0] = 0.0
  Angles[2] = 0.0

  entity_set_vector(RPG, EV_VEC_angles, Angles)

  new Float:MinBox[3] = {-16.0, -16.0, 0.0}
  new Float:MaxBox[3] = {16.0, 16.0, 16.0}
  entity_set_vector(RPG, EV_VEC_mins, MinBox)
  entity_set_vector(RPG, EV_VEC_maxs, MaxBox)

  entity_set_int(RPG, EV_INT_solid, 1)
  entity_set_int(RPG, EV_INT_movetype, 6)

  entity_set_int(RPG, EV_INT_iuser1, Munni[id])

  Munni[id] = 0
  hasBazooka[id] = false

  return PLUGIN_HANDLED
}

public handle_say(id) {
  new command[32]
  read_argv(1, command, 31)

  if (equal(command, "buy_weapon")) {
    if (find_ent_by_class(-1, "func_bomb_target") == 0) {
      if (is_user_alive(id)) {
        if (get_cvar_num("amx_bazooka_buyable") == 1) {
          show_buymenu(id)
        }
        else {
          client_print(id, print_chat, "[Bazooka] The buymenu is disabled!")
        }
      }
      else {
        client_print(id, print_chat, "[Bazooka] You cannot buy a bazooka while you are dead!")
      }
    }
    else {
      client_print(id, print_chat, "[Bazooka] The bazooka is disabled on this map!")
    }
  }

  return PLUGIN_CONTINUE
}

public show_buymenu(id) {

  new MenuBody[256]
  new len = format(MenuBody, 255, "\yBuy Item^n^n")
  len = len + format(MenuBody[len], 255 - len, "\w1. Bazooka\R$%d^n", get_cvar_num("amx_bazooka_cost"))
  len = len + format(MenuBody[len], 255 - len, "^n\w0. Exit^n")

  new keys = (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6|1<<7|1<<8|1<<9)

  show_menu(id, keys, MenuBody, -1, "Bazooka Menu")

  return PLUGIN_HANDLED
}

public do_bazookamenu(id, key) {
  switch(key) {
    case 0: {
      if (cs_get_user_money(id) >= get_cvar_num("amx_bazooka_cost")) {

        give_item(id, "weapon_c4")
        hasBazooka[id] = true
        Munni[id] = Munni[id] + get_cvar_num("amx_bazooka_ammo")

        cs_set_user_money(id, cs_get_user_money(id) - get_cvar_num("amx_bazooka_cost"))

        client_print(id, print_chat, "[Bazooka] You have successfully bought a bazooka!")
        client_print(id, print_chat, "[Bazooka] Use alternate fire (+attack2) to change the shooting mode!")
      }
      else {
        client_print(id, print_center, "You have insufficient funds!")
      }
    }
    case 9: {
    }
    default: {
      show_buymenu(id)
    }
  }

  return PLUGIN_HANDLED
}